using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static List<int> Greedy(List<(int a, long w, long v, double e)> list, long W)
    {
        long curW = 0;
        List<int> taken = new List<int>();

        foreach (var it in list)
        {
            if (curW + it.w <= W)
            {
                curW += it.w;
                taken.Add(it.a);
            }
        }
        return taken;
    }

    static void Main()
    {
        string[] s = Console.ReadLine().Split();
        int N = int.Parse(s[0]);
        long W = long.Parse(s[1]);
        double E = double.Parse(s[2]); // e se ne koristi direktno

        var items = new List<(int a, long w, long v, double e)>();

        for (int i = 0; i < N; i++)
        {
            string[] s1 = Console.ReadLine().Split();
            long wi = long.Parse(s1[0]);
            long vi = long.Parse(s1[1]);
            items.Add((i + 1, wi, vi, (double)vi / wi));
        }

        // Greedy po odnosu vrednost / težina
        var byRatio = items.OrderByDescending(x => x.e).ToList();
        // Greedy po vrednosti
        var byValue = items.OrderByDescending(x => x.v).ToList();

        var takeRatio = Greedy(byRatio, W);
        var takeValue = Greedy(byValue, W);

        // Racunamo ukupne vrednosti
        long valRatio = 0;
        foreach (int i in takeRatio)
            valRatio += items.First(x => x.a == i).v;

        long valValue = 0;
        foreach (int i in takeValue)
            valValue += items.First(x => x.a == i).v;

        // Biramo bolje rešenje
        var result = valRatio >= valValue ? takeRatio : takeValue;

        Console.WriteLine(result.Count);
        Console.WriteLine(string.Join(" ", result));
    }
}